//
//  RootViewController.m
//  TagDemo
//
//  Created by jcassidy on 10-11-15.
//  Copyright 2010 Visible Assets Inc.. All rights reserved.
//

#import "RootViewController.h"
#import "TagDemoAppDelegate.h"


@implementation RootViewController


#pragma mark -
#pragma mark View lifecycle

// ***************************************************************
// *
// * viewDidLoad = post load initialization; allocate array to hold controllers, then fill
// *
// ***************************************************************

- (void) viewDidLoad 
{
	[super viewDidLoad];
	 
	[self setTitle:@"Rubee TagDemo"];
	 
	// create an array to hold the view controllers that we'll present based on the table item selected
	controllerArray = [[NSMutableArray alloc] init];
	 
	// add the view controllers to our array
	statusViewController = [[StatusViewController alloc] init];
	[controllerArray addObject:statusViewController];
	
	discoveryViewController = [[DiscoveryViewController alloc] init];
	[controllerArray addObject:discoveryViewController];
	
	scanViewController = [[ScanViewController alloc] init];
	[controllerArray addObject:scanViewController];
}


/*
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
}
*/
/*
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
}
*/
/*
- (void)viewWillDisappear:(BOOL)animated {
	[super viewWillDisappear:animated];
}
*/
/*
- (void)viewDidDisappear:(BOOL)animated {
	[super viewDidDisappear:animated];
}
*/

/*
 // Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
	// Return YES for supported orientations.
	return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
 */


#pragma mark -
#pragma mark Table view data source

// Customize the number of sections in the table view.
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}


// ***************************************************************
// *
// * tableView:numberOfRowsInSection: - provide number of rows to display when requested 
// *
// ***************************************************************

- (NSInteger) tableView:(UITableView *) tableView numberOfRowsInSection:(NSInteger) section 
{
    return [controllerArray count];
}

// ***************************************************************
// *
// * tableView:cellForRowAtIndexPath: - use arrary of controllers to show list of selection possibilities
// *
// ***************************************************************

- (UITableViewCell *) tableView:(UITableView *) tableView cellForRowAtIndexPath:(NSIndexPath *) indexPath 
{
	NSInteger row; 
	static NSString *CellIdentifier = @"Cell";
    
	UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
	if (cell == nil) {
		cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
	}
    
	row = [indexPath row];
	[[cell textLabel] setText:[[controllerArray objectAtIndex:row] title]];
	return cell;
}


/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/


/*
// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source.
        [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view.
    }   
}
*/


/*
// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
}
*/


/*
// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}
*/


#pragma mark -
#pragma mark Table view delegate

// ***************************************************************
// *
// * tableView: didSelectRowAtIndexPath: - show selected view controller from our array of controllers
// *
// ***************************************************************

- (void)tableView:(UITableView *) tableView didSelectRowAtIndexPath:(NSIndexPath *) indexPath 
{
	NSUInteger				row;
	UIViewController		*viewController;
	TagDemoAppDelegate	*delegate;
	
	row = [indexPath row];
	viewController = [controllerArray objectAtIndex:row];
	delegate = [[UIApplication sharedApplication] delegate];
	[[delegate navigationController] pushViewController:viewController animated:YES];
}


#pragma mark -
#pragma mark Memory management

// ***************************************************************
// *
// * didReceiveMemoryWarning = low on memory, release as much as possible
// *
// ***************************************************************

- (void) didReceiveMemoryWarning 
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Relinquish ownership any cached data, images, etc that aren't in use.
}

// ***************************************************************
// *
// * viewDidUnload = undo allocations made in viewDidLoad
// *
// ***************************************************************

- (void) viewDidUnload 
{
    // Relinquish ownership of anything that can be recreated in viewDidLoad or on demand.
    // For example: self.myOutlet = nil;
}

// ***************************************************************
// *
// * dealloc = release local allocations
// *
// ***************************************************************

- (void) dealloc 
{
	[controllerArray dealloc];
	[super dealloc];
}


@end

