//
//  ScanViewController.m
//  TagTool
//
//  Created by jcassidy on 14/11/09.
//  Copyright 2009 Visible Assets Inc.. All rights reserved.
//

#import "ScanViewController.h"
#import "IAPLink.h"
#import "AudioToolBox/AudioServices.h"
#import "TagDemoAppDelegate.h"

@implementation ScanViewController

// ***************************************************************
// *                                                             
// * initWithNibName =  nib loaded from bundle, perform initialization
// *
// ***************************************************************

- (id) initWithNibName:(NSString *) nibName bundle:(NSBundle *) nibBundle 
{
    if (self = [super initWithNibName:nibName bundle:nibBundle]) {
		[self setTitle:@"Bar Code Scanner"];
    }
    return self;
}


/*
// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
}
*/

/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

// ***************************************************************
// *                                                             
// * didReceiveMemoryWarning = notification by OS that memory is low, release uneeded objects
// *
// ***************************************************************

- (void) didReceiveMemoryWarning 
{
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void) viewDidUnload 
{
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}

- (void) appendString: (NSString *) string
{
	NSString *text;
	
	text = [textView text];
	
	textView.text = [string stringByAppendingString: text];
	[textView setNeedsDisplay];
	//	[textView scrollRangeToVisible:NSMakeRange( [textView.text length], 0 ) ]; 
}	

- (void) scan:(id) sender
{
	char		buffer[ 50 ];
	NSString	*string;
	Timer		*timer;
	BaseStation *baseStation;
	
	// get base station object for later use
	baseStation = [(TagDemoAppDelegate *) [[UIApplication sharedApplication]  delegate] baseStation];
	
	// clear out the scan response buffer, then trigger the scanner
	memset( buffer, 0, 50 );
	[[baseStation communicationsLink] triggerScanner];
	
	// wait for at least 3 seconds (the scan timeout value), or until a scan arrives
	timer = [[Timer alloc] init];
	[timer setDuration:3.2];
	do {
		string = [[baseStation communicationsLink] readScanner];
	} while( ![timer timeout] && [string length] == 0 );
	
	// NR means no bar code was found
	if( [string hasPrefix:@"NR"] || [string length] == 0 )
		strcpy( buffer, "-" );
	else
		[self beep];

	[self appendString:string];
	printf( "%s\n", [string UTF8String] );
}

- (void) beep
{
	NSString		*path;
	SystemSoundID	soundID;
	NSURL			*filePath;

	path = [NSString stringWithFormat:@"%@/%@", [[NSBundle mainBundle] resourcePath], @"Ping.aiff"];
	filePath = [NSURL fileURLWithPath:path isDirectory:NO];
	AudioServicesCreateSystemSoundID( (CFURLRef) filePath, &soundID );
	AudioServicesPlaySystemSound( soundID );
}

@end
