//
//  StatusViewController.m
//  RubeeTagManager
//
//  Created by jcassidy on 10-07-10.
//  Copyright 2010 Visible Assets Inc.. All rights reserved.
//

#import "StatusViewController.h"
#import "BaseStation.h"
#import "TagDemoAppDelegate.h"

@implementation StatusViewController


- (id) initWithNibName:(NSString *) nibNameOrNil bundle:(NSBundle *) nibBundleOrNil 
{
    if( ( self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil] ) ) {
		[self setTitle:@"Application Info"];
    }
    return self;
}



// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad 
{
	[super viewDidLoad];
	[self getAndDisplayInfo];
}


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void) didReceiveMemoryWarning 
{
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

- (void) viewDidUnload 
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void) dealloc 
{
    [super dealloc];
}

// ***************************************************************
// *                                                             
// * getAndDisplayInfo =  display system status and version info                      
// *                                                             
// ***************************************************************

- (void) getAndDisplayInfo
{
	int			version;
	BaseStation *baseStation;
	
	baseStation = [(TagDemoAppDelegate *) [[UIApplication sharedApplication]  delegate] baseStation];
	
	version = [[baseStation communicationsLink] firmwareVersion];
	[firmwareVersionLabel setText:[NSString stringWithFormat:@"%d", version]];
	[baseStationVersionLabel setText:[NSString stringWithFormat:@"%d", [baseStation firmwareVersion]]];
	[softwareVersionLabel setText:[NSString stringWithFormat:@"%0.1f", [(TagDemoAppDelegate *) [[UIApplication sharedApplication]  delegate] version]]];
}

// ***************************************************************
// *                                                             
// * help =  jump to rubee.com                 
// *                                                             
// ***************************************************************

- (void) help:(id) sender
{
	NSURL *url;
	UIAlertView *alert;
	
	url = [NSURL URLWithString:@"http://www.rubee.com/pRap/tt"];	
	if( ![[UIApplication sharedApplication] openURL:url] )	{	
		alert = [[UIAlertView alloc] initWithTitle:@"Error" message:@"Unable to open web page." delegate:self cancelButtonTitle:nil otherButtonTitles:@"OK", nil];
		[alert show];
		[alert release];
		return;
	}	
}

	
@end
