// ************************************************************************
// *
// * Module:	    BaseStation.h/cc
// * Purpose:		Provide basestation control functions
// *
// ************************************************************************
// ************************************************************************
// *                         INCLUDE FILES
// ************************************************************************

#import <Foundation/Foundation.h>
#import "CommunicationsLink.h"
#import "StreamReader.h"

// ************************************************************************
// *                         MANIFEST CONSTANTS
// ************************************************************************

// basestation/tag constants
#define RESPONSE_TIMEOUT_MS		2500
#define MAX_TUNING_SETTING		32
#define MAX_SIGNAL_AMPLITUDE	5500L

#define AUTO_TUNE	-1
#define ANTENNA_1	 1
#define ANTENNA_2	 2
#define ANTENNA_3	 3
#define ANTENNA_4	 4

// basestation types
#define BLASTER_TYPE			0
#define BLADE_TYPE				1

// ************************************************************************
// *                         CLASS DEFINITION
// ************************************************************************

@interface BaseStation : NSObject {
	int								type;
	StreamReader					*communicationsLinkPtr;
	long							lastCrossCorrelation;
	long							lastSignalAmplitude;
	int								maxTuningSetting;
	int								currentAntenna;
	int								tuningValues[ 4 ];
}
	
@property (nonatomic, assign) int type;

- (BOOL) initialize:(NSString *) initString antenna:(int) antennaSetting gain:(int) gain tuning:(int) userTuning currentTable:(int *) currentTable; 
- (BOOL) open:(NSString *) initString;
- (void) dealloc;
- (BOOL) ping;
- (int)  firmwareVersion;
- (void) setTurnaroundDelay:(int) delay; 
- (int)  tuneBasestation:(int) antennaSetting gain:(int) gain tuning:(int) userTuning currentTable:(int *) currentTable;
- (BOOL) sendCommand:(char *) commandString response:(char *) responseString length:(int) responseLength;
//- (BOOL) readResponse:(char *) responseString length:(int) length timeout:(int) ms;
- (long) signalAmplitude;
- (long) signalNoise;
- (long) crossCorrelation;
- (BOOL) isSignalValid:(long) signalAmplitudeValue amplitudeThreshold:(long) signalAmplitudeThreshold correlation:(long) correlationValue correlationThreshold:(long) correlationSignalRatioThreshold; 
- (BOOL) validateLastSignal:(long) signalAmplitudeThreshold correlationThreshold:(long) correlationSignalRatioThreshold;
- (long) lastCrossCorrelation;
- (long) lastSignalAmplitude;
- (int)  hexToInt:(char *) hexString;
- (int)  hexDigitToInt:(char)  h;
- (int)  maxTuningSetting;			// old method for single antenna 
- (int)  maxTuningSetting:(int) a;	// new method for multiple antennas
- (void) selectAntenna:(int) a;
- (BOOL) isConnected;
- (void) setTimingP:(int) p R:(int) r;
- (StreamReader *) communicationsLink; 


@end
