// ************************************************************************
// *                                                                      
// * Module:		CommunicationsLink.h                                  
// * Purpose:	Abstract superclass for communications related classes
// *                                                                       
// ************************************************************************

#import <Foundation/Foundation.h>

#define UNKNOWN -1

@interface CommunicationsLink : NSObject {
	BOOL blockMode;
}

- init;
- (void) dealloc;
- (void) initializeInstanceVars;	

// open/close connection member functions
- (BOOL) open:(NSString *) string;					// open link
- (BOOL) close;										// close link
- (BOOL) isConnected;								// return true if connected
	
// instance var access functions
- (void) setBlockMode:(int) m;						// set blocking mode, TRUE = block
- (int)  getBlockMode;								// get blocking mode, TRUE = block
	
// data I/O
- (size_t) writeData:(char *) data length:(size_t) l;	// write data to socket
- (size_t) readData:(char *) data length:(size_t) l;	// read data from socket
- (int) bufferLevel;									// return bytes in rx buffer

- (size_t) writeChannel:(int) channel data:(char *) data length:(size_t) l;		// write data to socket
- (size_t) readChannel:(int) channel data:(char *) data length:(size_t) l;		// read data from socket

// misc
- (int) setBufferSize:(int) size;						// set rx buffer size in Kbytes	
- (int) firmwareVersion;
- (void) clear;
- (void) triggerScanner;
- (NSString *) readScanner;

@end

