//
//  IAPLink.h
//  SocketTest
//
//  Created by jcassidy on 07/06/09.
//  Copyright 2009 Visible Assets Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CommunicationsLink.h"
#include "Timer.h"
#import <ExternalAccessory/ExternalAccessory.h>

#define DEFAULT_TIMEOUT				5

#define ACCESSORY_CHANNEL			0
#define SCANNER_CHANNEL				1
#define TRANSCEIVER_CHANNEL		2
#define READER_CHANNEL					3
#define ETHERNET_CHANNEL				4

#define ACMD_PING							0
#define ACMD_VER							1
#define ACMD_LISTEN						2
#define ACMD_SCANNER_INIT			3
#define ACMD_ETHERNET_INIT			4

#define ARSP_NAK							0
#define ARSP_ACK								1

@interface IAPLink : CommunicationsLink {
	EAAccessory		*accessory;
	EASession			*session;
	NSInputStream		*inputStream;
	NSOutputStream	*outputStream;
		
	Timer				*timer;
	float				timeout;						// timeout in seconds in blocking mode
}

- init;													// set inital state
- (void) dealloc;

// open/close connection member functions
- (BOOL) open:(NSString *) initString;					// open client socket
- (BOOL) close;											// close client socket

// instance var access functions
- (void) setBlockMode:(int) mode;						// set blocking mode, TRUE = block

// data I/O 
- (size_t)	writeChannel:(int) channel data:(char *) data length:(size_t) l;	// write data to socket
- (size_t)	readChannel:(int) channel data:(char *) data length:(size_t) l;	// read data from socket
- (size_t)	bufferLevel;														// return bytes in rx buffer
- (void)		stream:(NSStream *) stream handleEvent:(NSStreamEvent) streamEvent;

- (NSString *) readString;								// return autoreleased nsstring

// misc
- (int) setBufferSize:( int ) size;							// set rx buffer size in Kbytes
- (void) initializeInstanceVars;
- (BOOL) ping;
- (int) firmwareVersion;
- (int) listen:(char *) data;
- (BOOL) scannerInit;
- (BOOL) ethernetInit;

@end
