//
//  RingBuffer.h
//  VisibleArmory
//
//  Created by jcassidy on 10-05-23.
//  Copyright 2010 Visible Assets Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface RingBuffer : NSObject {
	NSMutableData		*buffer;
	unsigned char		*startPtr;
	unsigned char		*endPtr;
	unsigned char		*writePtr;
	unsigned char		*readPtr;
	int					length;
}

- init:(int) size;
- (void) initialize:(int) len; 
- (void) dealloc;
- (void) clear;
- (BOOL) write:(unsigned char) c;
- (BOOL) read:(unsigned char *) cPtr; 
- (int) bytesAvailable;
- (BOOL) isEmpty;
- (int) read:(unsigned char *) ptr maxLength:(int) len;
- (BOOL) write:(unsigned char *) data length:(int) len;
- (int) scan:(char) searchChar;

@end
