//
//  Socket.h
//  SocketTest
//
//  Created by jcassidy on 07/06/09.
//  Copyright 2009 Visible Assets Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CommunicationsLink.h"
#include "Timer.h"

#define DEFAULT_LISTEN_QUEUE_SIZE	10
#define DEFAULT_TIMEOUT				5

@interface Socket : CommunicationsLink {
	int		socketDescriptor;					// descriptor for open socket
	int		tcpPortNumber;						// port for connecting
	char	*hostName;						// name of host to connect with
	int		listenQueueSize;					// max number of pending connections	
	
	Timer	*timer;
	float	timeout;							// timeout in seconds in blocking mode
}

- init;												// set inital state
- (void) dealloc;

// open/close connection member functions
- (BOOL) open:(NSString *) initString;				// open client socket
- (BOOL) close;									// close client socket

// open/close socket member functions
- (BOOL) openClientSocketToPort:(int) port host:(NSString * ) host;	// open this specified client port
- (BOOL) openClientSocket;							// open previously specified client port
- (BOOL) openServerSocket;							// open previously specified server port
- (BOOL) closeSocket;								// close previously opened socket
	
// instance var access functions
- (void) setPort:(int) port;						// set port number for connection
- (void) setHost:(char *) host;					// set host to connect with
- (char*) getHost;							// return host string
- (void) setBlockMode:(int) mode;				// set blocking mode, TRUE = block
//- (void) setListenQueueSize:(int) size;				// set max pending connections
	
// data I/O 
- (size_t)	writeData:(char *) data length:(size_t) l;	// write data to socket
- (size_t)	readData:(char *) data length:(size_t) l;	// read data from socket
- (size_t)	bufferLevel;						// return bytes in rx buffer
- (NSString *) readString;						// return autoreleased nsstring
/*- (int)	writeByte( int );						// write 8 bit byte to socket
- (int)	writeInt16( int );					// write 16 bit word to socket
- (int)	writeInt32( int );					// write 32 bit word to socket
- (int)	readByte( void );					// read 8 bit byte from socket
- (int)	readInt16( void );					// read 16 bit word from socket
- (int)	readInt32( void );					// read 32 bit word from socket*/
	
// misc
- (int) setBufferSize:( int ) size;				// set rx buffer size in Kbytes
- (void) initializeInstanceVars;

// server socket support
- (void) startListening;					// start listening, servers only
//	Socket	*acceptConnection( void );		// wait for client connection

@end
