// ************************************************************************
// *
// * Module:	    TagCommand.h/cc
// * Purpose:		Provide simple wrapper for tag command
//
// ************************************************************************
// ************************************************************************
// *                         INCLUDE FILES
// ************************************************************************

// system includes
#import <Foundation/Foundation.h>

// program specific includes
#include <stdio.h>

// ************************************************************************
// *                         MANIFEST CONSTANTS
// ************************************************************************

// ************************************************************************
// *                         CLASS DEFINITION
// ************************************************************************

@interface TagCommand : NSObject {
	char	command;			// command value nybble
	char	sync[ 5 ];			// sync prefix
	int		txDataLength;		// number of nybbles in tx data
	int		txAddrLength;		// number of nybbles in tx addr
	int		rxDataLength;		// number of nybbles in receive data
	int		responseLength;	//
	int		checkType;			//
	int		checksumStart;		//
	int		checksumEnd;		//
	char	eodMarker[ 5 ];		// end of data marker	
}

@property char		command;
@property int		txDataLength;
@property int		txAddrLength;
@property int		rxDataLength;
@property int		responseLength;
@property int		checkType;
@property int		checksumStart;
@property int		checksumEnd;

// constructor/destructor
- init;
- (void) initCommand:(char) newCommand
		sync:(char *) newSync
		txDataLength:(int) newTxDataLength
		txAddrLength:(int) newTxAddrLength
		rxDataLength:(int) newRxDataLength
		responseLength:(int) newResponseLength
		checkType:(int) newCheckType
		checksumStart:(int) newChecksumStart
		checksumEnd:(int) newChecksumEnd
		eodMarker:(char *) newEodMarker;
- (void) dealloc;
- (char *) sync;
- (char *) eodMarker;

@end

